<?php

namespace NewfoldLabs\WP\Module\Onboarding\RestApi\Themes;

use NewfoldLabs\WP\Module\Onboarding\Permissions;
use NewfoldLabs\WP\Module\Onboarding\Data\Themes\Colors;

/**
 * Class ThemeColorsController
 */
class ThemeColorsController extends \WP_REST_Controller {


	 /**
	  * The namespace of this controller's route.
	  *
	  * @var string
	  */
	 protected $namespace = 'newfold-onboarding/v1';

	 /**
	  * The base of this controller's route.
	  *
	  * @var string
	  */
	 protected $rest_base = '/themes';


	 /**
	  * The extended base of this controller's route.
	  *
	  * @var string
	  */
	 protected $rest_extended_base = '/colors';



	 /**
	  * Registers routes for ThemeColorsController
	  */
	public function register_routes() {
		\register_rest_route(
			$this->namespace,
			$this->rest_base . $this->rest_extended_base,
			array(
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array( $this, 'get_theme_colors' ),
					'permission_callback' => array( Permissions::class, 'rest_is_authorized_admin' ),
				),
			)
		);
	}

	 /**
	  * Retrieves the active theme color variations.
	  *
	  * @return array|\WP_Error
	  */
	public function get_theme_colors() {
		 $theme_color_palettes = Colors::get_colors_from_theme();
		 return $theme_color_palettes;
	}
}
