<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package GEYA
 * @since GEYA 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$geya_copyright_scheme = geya_get_theme_option( 'copyright_scheme' );
if ( ! empty( $geya_copyright_scheme ) && ! geya_is_inherit( $geya_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $geya_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$geya_copyright = geya_get_theme_option( 'copyright' );
			if ( ! empty( $geya_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$geya_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $geya_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$geya_copyright = geya_prepare_macros( $geya_copyright );
				// Display copyright
				echo wp_kses( nl2br( $geya_copyright ), 'geya_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
