<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package GEYA
 * @since GEYA 1.0
 */

// Page (category, tag, archive, author) title

if ( geya_need_page_title() ) {
	geya_sc_layouts_showed( 'title', true );
	geya_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								geya_show_post_meta(
									apply_filters(
										'geya_filter_post_meta_args', array(
											'components' => join( ',', geya_array_get_keys_by_value( geya_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', geya_array_get_keys_by_value( geya_get_theme_option( 'counters' ) ) ),
											'seo'        => geya_is_on( geya_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$geya_blog_title           = geya_get_blog_title();
							$geya_blog_title_text      = '';
							$geya_blog_title_class     = '';
							$geya_blog_title_link      = '';
							$geya_blog_title_link_text = '';
							if ( is_array( $geya_blog_title ) ) {
								$geya_blog_title_text      = $geya_blog_title['text'];
								$geya_blog_title_class     = ! empty( $geya_blog_title['class'] ) ? ' ' . $geya_blog_title['class'] : '';
								$geya_blog_title_link      = ! empty( $geya_blog_title['link'] ) ? $geya_blog_title['link'] : '';
								$geya_blog_title_link_text = ! empty( $geya_blog_title['link_text'] ) ? $geya_blog_title['link_text'] : '';
							} else {
								$geya_blog_title_text = $geya_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $geya_blog_title_class ); ?>">
								<?php
								$geya_top_icon = geya_get_term_image_small();
								if ( ! empty( $geya_top_icon ) ) {
									$geya_attr = geya_getimagesize( $geya_top_icon );
									?>
									<img src="<?php echo esc_url( $geya_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'geya' ); ?>"
										<?php
										if ( ! empty( $geya_attr[3] ) ) {
											geya_show_layout( $geya_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $geya_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $geya_blog_title_link ) && ! empty( $geya_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $geya_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $geya_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'geya_action_breadcrumbs' );
						$geya_breadcrumbs = ob_get_contents();
						ob_end_clean();
						geya_show_layout( $geya_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
